/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.auiml.databeans.locale.LanguageSetBean;
import com.ibm.hsc.common.util.AuimlAdapter;
import com.ibm.hsc.websm.launch.hscmgt.SystemConfigurationOverview;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskManagerException;
import com.ibm.ui.framework.TaskNotifyCompleteEvent;
import com.ibm.ui.framework.TaskNotifyCompleteListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class Launch5250
implements TaskNotifyCompleteListener,
TaskActionListener {
    private static final String IBM5250 = "/opt/hsc/bin/ibm5250";
    private String m_emulator = "/opt/hsc/bin/ibm5250";
    private String m_hostname = null;
    private int m_port = -1;
    private boolean m_selectLocale = true;
    private String m_locale = null;
    private UserTaskManager m_utm = null;
    private LanguageSetBean m_bean = new LanguageSetBean();
    private boolean m_showEmulator = false;

    public Launch5250() {
    }

    public Launch5250(String string, int n, String string2) {
        this.m_hostname = string;
        this.m_port = n;
        this.m_selectLocale = false;
        this.m_locale = string2;
        this.m_showEmulator = true;
    }

    private void showLocaleSelection() throws Exception {
        this.m_bean.load();
        String[] stringArray = null;
        System.err.println("Getting locale list...");
        try {
            stringArray = SystemConfigurationOverview.getLocaleList();
        }
        catch (Exception exception) {
            System.err.println("Get locale list failed.");
            exception.printStackTrace();
        }
        ValueDescriptor[] valueDescriptorArray = null;
        System.err.println("Process locale list.");
        if (stringArray != null && stringArray.length > 0) {
            int n;
            int n2 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n] == null) continue;
                ++n2;
            }
            valueDescriptorArray = new ValueDescriptor[n2];
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n] == null) continue;
                valueDescriptorArray[n] = new ValueDescriptor(stringArray[n], stringArray[n]);
            }
        }
        this.m_bean.setLocaleList(valueDescriptorArray);
        String string = null;
        System.err.println("Getting current locale...");
        try {
            string = SystemConfigurationOverview.getLocale();
        }
        catch (Exception exception) {
            System.err.println("Get current locale failed: defaulting to en_US.");
            exception.printStackTrace();
            string = "en_US";
        }
        System.err.println("Processing locale.");
        this.m_bean.setLocale(string);
        try {
            DataBean[] dataBeanArray = new DataBean[]{this.m_bean};
            AuimlAdapter auimlAdapter = new AuimlAdapter("com.ibm.hsc.auiml.databeans.locale.LanguageSet", "LangSetPanel", dataBeanArray);
            auimlAdapter.init();
            this.m_utm = auimlAdapter.getUserTaskManager();
            this.m_utm.addTaskActionListener((TaskActionListener)this);
            this.m_utm.addTaskNotifyCompleteListener((TaskNotifyCompleteListener)this, "String4");
            this.m_utm.addCancelListener((TaskActionListener)this);
            System.err.println("Show locale selection panel.");
            auimlAdapter.showIt();
        }
        catch (TaskManagerException taskManagerException) {
            taskManagerException.printStackTrace();
            throw taskManagerException;
        }
    }

    public void taskCompleted(TaskNotifyCompleteEvent taskNotifyCompleteEvent) {
        String string = taskNotifyCompleteEvent.getValue();
        this.m_bean.setLocale(string);
    }

    public synchronized void actionPerformed(TaskActionEvent taskActionEvent) {
        String string = taskActionEvent.getActionCommand();
        System.err.println("Launch5250.actionPerformed(): " + string);
        if (string.compareTo("OK") == 0 || string.compareTo("COMPLETE") == 0) {
            this.m_locale = this.m_bean.getLocale();
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(this.m_locale);
                this.m_locale = stringTokenizer.nextToken().trim();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.m_showEmulator = true;
        } else {
            this.m_showEmulator = false;
        }
        this.notify();
        this.m_utm.dispose();
        this.m_utm = null;
    }

    public synchronized void launchEmulator() throws IOException {
        this.m_locale = null;
        this.m_showEmulator = true;
        if (this.m_showEmulator) {
            StringBuffer stringBuffer = new StringBuffer(this.m_emulator);
            if (this.m_hostname != null) {
                stringBuffer.append(' ').append(this.m_hostname);
            }
            if (this.m_port != -1) {
                stringBuffer.append(" -port ").append(this.m_port);
            }
            if (this.m_locale != null) {
                stringBuffer.append(" -LANGID ").append(this.m_locale);
            }
            System.err.println("Launching 5250 emulator: \"" + stringBuffer.toString() + "\"");
            Runtime runtime = Runtime.getRuntime();
            runtime.exec(stringBuffer.toString());
        }
    }

    public String getEmulator() {
        return this.m_emulator;
    }

    public void setEmulator(String string) {
        this.m_emulator = string;
    }

    public String getHostname() {
        return this.m_hostname;
    }

    public void setHostname(String string) {
        this.m_hostname = string;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int n) {
        this.m_port = n;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public void setLocale(String string) {
        this.m_locale = string;
    }

    public static boolean doesEmulatorExist() {
        File file = new File(IBM5250);
        boolean bl = false;
        try {
            bl = file.exists();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return bl;
    }
}

